(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.1'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     27473,        761]*)
(*NotebookOutlinePosition[     28173,        785]*)
(*  CellTagsIndexPosition[     28129,        781]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["Transformada de Fourier Discreta", "Title"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Soluciones de los ejercicios", "Section"]], "Section"],

Cell[CellGroupData[{

Cell["Ejercicio 1", "Exercise"],

Cell[TextData[{
  "a) Define un comando que proporcione simb\[OAcute]licamente los vectores \
\[Omega][n,N]  (",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] n \[LessEqual] N - 1\)]],
  ").\nb) Comprueba para ",
  Cell[BoxData[
      \(TraditionalForm\`N = 6\)]],
  " que los vectores antes definidos forman una base ortogonal de ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalC]\^6\)]],
  ". Usa el comando Simplify[ ] si es preciso.\nc) Define un comando \
DFT[lista] que proporcione la transformada de Fourier discreta de \"lista\". \
Usa para ello los vectores \[Omega][n,N] y el producto escalar.\nObservaci\
\[OAcute]n: Claro est\[AAcute] que este comando no es \[UAcute]til para hacer \
c\[AAcute]lculos largos, pero tiene la ventaja de que puede trabajar simb\
\[OAcute]licamente lo que nos permite entender bien lo que hace. \nd) Decimos \
que la se\[NTilde]al ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["y",
            FontWeight->"Bold"], "=", \((y\_0, y\_1,  ... , y\_\(N - 1\))\)}],
         TraditionalForm]]],
  " es par si es sim\[EAcute]trica respecto de ",
  Cell[BoxData[
      \(TraditionalForm\`N/2\)]],
  " (suponemos que ",
  StyleBox["N",
    FontSlant->"Italic"],
  " es par), es decir, si ",
  Cell[BoxData[
      \(TraditionalForm\`y\_\(N/2 - k\) = y\_\(N/2 + k\)\)]],
  " para ",
  Cell[BoxData[
      \(TraditionalForm\`k = 0, 1,  ... , \ N/2 - 1\)]],
  ". Decimos que ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["y",
            FontWeight->"Bold"], "=", \((y\_0, y\_1,  ... , y\_\(N - 1\))\)}],
         TraditionalForm]]],
  " es impar si es antisim\[EAcute]trica respecto de ",
  Cell[BoxData[
      \(TraditionalForm\`N/2\)]],
  ", es decir, si ",
  Cell[BoxData[
      \(TraditionalForm\`y\_\(N/2 - k\) = \(-y\_\(N/2 + k\)\)\)]],
  " para ",
  Cell[BoxData[
      \(TraditionalForm\`k = 0, 1,  ... , \ N/2 - 1\)]],
  ". \nDefine comandos \"par[se\[NTilde]al]\"  (\"impar[se\[NTilde]al]\") que \
transformen una se\[NTilde]al (finita) dada en otra se\[NTilde]al par (impar) \
de forma que se verifique la igualdad\n\t\t\tse\[NTilde]al = \
par[se\[NTilde]al] + impar[se\[NTilde]al]\nadem\[AAcute]s, si la \
se\[NTilde]al es par debe ser  se\[NTilde]al = par[se\[NTilde]al].\n\
Sugerencia: Usa el comando Reverse[].\ne) Define un comando \"rlist[n]\" que \
genere aleatoriamente una lista de n n\[UAcute]meros. Define a= rlist[32]. \
Calcula DFT[a] y comprueba por simple inspecci\[OAcute]n que todos sus \
elementos son reales y es par. Calcula DFT[impar[a]] y comprueba por simple \
inspecci\[OAcute]n que todos sus elementos, excepto el primero y el que ocupa \
el lugar 17, son imaginarios puros y es impar. Comprueba, usando ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", que DFT[a] = DFT[par[a]] + DFT[impar[a]].\nSugerencia: Debes usar el \
comando Chop[ ] para eliminar las peque\[NTilde]as partes imaginarias o \
reales procedentes de errores de redondeo.\nf) Define un comando \
\"InverseDFT[lista]\" que calcule la inversa de la transformada de Fourier \
discreta. "
}], "ExerciseText"],

Cell[BoxData[
    RowBox[{\(\[Omega][n_, N_] := 
        Exp[2  \[ImaginaryI]\ \[Pi]\ n\ Range[0, N - 1]/N]\), " ", 
      RowBox[{"(*", " ", 
        RowBox[{"los", " ", "vectores", " ", 
          FormBox[
            SubscriptBox[
              StyleBox["\[Omega]",
                FontWeight->"Bold"], "n"],
            "TraditionalForm"], " ", "en", " ", \(\[DoubleStruckC]\^N\)}], 
        " ", "*)"}]}]], "Input"],

Cell[BoxData[
    \(DFT[
        muestra_] := \(Table[
            1/Length[muestra] \((\ 
                muestra . \[Omega][\(-n\), Length[muestra]])\), {n, 0, 
              Length[muestra] - 1}] // Simplify\) // Chop\)], "Input"],

Cell[TextData[{
  "Vamos a comprobar que los vectores ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["\[Omega]",
            FontWeight->"Bold"], "n"], TraditionalForm]]],
  " forman una base ortogonal."
}], "Text"],

Cell[BoxData[
    \(\(\(Table[\[Omega][n, 6], {n, 0, 
          5}]\)\(//\)\(\(MatrixForm\)\(\ \ \)\)\( (*\ 
        hacemos\ N = 6\ *) \)\)\)], "Input"],

Cell[BoxData[
    \(\(\(Table[\[Omega][n, 6], {n, 0, 5}] . 
          Conjugate[Table[\[Omega][n, 6], {n, 0, 5}]]\  // 
        MatrixForm\)\(\ \)\(//\)\(Simplify\)\( (*\ 
        comprobamos\ que\ son\ ortogonales\ y\ su\ norma\ igual\ a\ \@6\ *) \
\)\)\)], "Input"],

Cell["\<\
Las siguientes operaciones te indican c\[OAcute]mo calcular la transformaci\
\[OAcute]n inversa.\
\>", "Text"],

Cell[BoxData[
    \(Simplify[DFT[DFT[{a, b, c, d, e, f}]]]\)], "Input"],

Cell[BoxData[
    \(Reverse[%]\)], "Input"],

Cell[BoxData[
    \(RotateRight[%]\)], "Input"],

Cell[BoxData[
    \(\(\(6\) \( RotateRight[
        Reverse[Simplify[DFT[DFT[{a, b, c, d, e, f}]]]]]\)\(\ \)\)\)], "Input"],

Cell[BoxData[{
    \(\(revertida[list_] := 
        RotateRight[Reverse[list]];\)\), "\[IndentingNewLine]", 
    \(invDFT[muestra_] := Length[muestra]*revertida[DFT[muestra]]\)}], "Input"],

Cell[BoxData[{
    \(par[list_] := \((list + revertida[list])\)/2\), "\[IndentingNewLine]", 
    \(impar[list_] := \((list - revertida[list])\)/2\)}], "Input"],

Cell[BoxData[{
    \(rdmlist[n_] := Table[Random[], {n}]\), "\[IndentingNewLine]", 
    \(\(a = rdmlist[32];\)\), "\[IndentingNewLine]", 
    \(DFT[par[a]] \[Equal] par[DFT[par[a]]]\), "\n", 
    \(DFT[impar[a]] \[Equal] impar[DFT[impar[a]]]\), "\[IndentingNewLine]", 
    \(revertida[DFT[a]] == Conjugate[DFT[a]]\), "\[IndentingNewLine]", 
    \(Clear[a]\)}], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 2", "Exercise"],

Cell[TextData[{
  "Considera la extensi\[OAcute]n 2\[Pi]-peri\[OAcute]dica de la funci\
\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`f[t] = t\ Sin[t]\)]],
  "  (",
  Cell[BoxData[
      \(TraditionalForm\`\(-\[Pi]\) \[LessEqual] t \[LessEqual] \[Pi]\)]],
  "). Pide a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " que construya una tabla de tres columnas con encabezados \"n\", \"c[n]\", \
\"Y[n]\"; donde n toma valores de 0 a 12; c[n] son los coeficientes de \
Fourier de ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  "; Y[n] son los valores de la transformada de Fourier discreta de una \
muestra de la extensi\[OAcute]n 2\[Pi]-peri\[OAcute]dica de ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " en ",
  Cell[BoxData[
      \(TraditionalForm\`N\)]],
  " puntos igualmente espaciados del intervalo ",
  Cell[BoxData[
      \(TraditionalForm\`\([0, 2  \[Pi]]\)\)]],
  ". Haz dos tablas correspondientes a ",
  Cell[BoxData[
      \(TraditionalForm\`N = 30\)]],
  " y a ",
  Cell[BoxData[
      \(TraditionalForm\`N = 100\)]],
  ". \nSugerencia: Puedes definir un comando que dependa de un \
par\[AAcute]metro ",
  Cell[BoxData[
      \(TraditionalForm\`k\)]],
  " y que d\[EAcute] como salida la tabla que se pide. El comando TableForm[] \
puede ser \[UAcute]til. Procura hacer los c\[AAcute]lculos de forma num\
\[EAcute]rica."
}], "Text"],

Cell[BoxData[
    \(f[t_] := \(\(Abs[t - 2  N[\[Pi]] Round[t/\((2  N[\[Pi]])\)]]\) \(Sin[
          Abs[t - 2  N[\[Pi]] Round[t/\((2  N[\[Pi]])\)]]]\)\( (*\ 
          extensi\[OAcute]n\ 2  \[Pi] - peri\[OAcute]dica\ de\ f[t] = 
            t\ Sin[t]\ *) \)\)\)], "Input"],

Cell[BoxData[
    \(\(Plot[f[t], {t, \(-4\) Pi, 4  Pi}];\)\)], "Input"],

Cell[BoxData[{
    \(Clear[f, sample, trans]\), "\[IndentingNewLine]", 
    \(\(f[t_] := 
        t*Sin[t] /; \(-N[\[Pi]]\) \[LessEqual] t \[LessEqual] 
            N[\[Pi]];\)\), "\n", 
    \(\(f[t_] := 
        f[t - 2  N[\[Pi]]] /; t > N[\[Pi]];\)\), "\[IndentingNewLine]", 
    \(sample[k_] := 
      f /@ \((\(N[2  \[Pi]]\/k\) Range[0, k - 1])\) // Chop\), "\n", 
    \(\(c[k_] = 
        Simplify[\(1\/\(2  \[Pi]\)\) 
            Integrate[\[ExponentialE]\^\(\(-k\)\ \[ImaginaryI]\ t\)\ t*
                Sin[t], {t, \(-\[Pi]\), \[Pi]}], 
          k \[Element] Integers];\)\), "\n", 
    \(c[1] = \(-1\)/4\ ;  (*\ 
      coeficientes\ de\ Fourier\ de\ f\ \
*) \[IndentingNewLine]\(\(comparacoeff[k_]\)\(:=\)\(CompoundExpression[
        trans = DFT[sample[k]]; 
        TableForm[
          Table[{j, N[c[j]], trans[\([j + 1]\)]}, {j, 0, Min[k/2, 15] - 1}], 
          TableHeadings -> {\ {}, {"\<n\>", "\<c[n]\>", "\<Y[n,\>" <> 
                  ToString[TraditionalForm[k]] <> "\<]\>"}}, 
          TableAlignments \[Rule] Left]]\)\( (*\ 
        no\ comparamos\ m\[AAcute]s\ que\ los\ primeros\ 15\ coeficientes\ \
para\ evitar\ c\[AAcute]lculos\ demasiado\ largos\ *) \)\)\)}], "Input"],

Cell[BoxData[{
    \(Clear["\<Global`*\>"]\), "\[IndentingNewLine]", 
    \(f[t_] := t*Sin[t]\), "\[IndentingNewLine]", 
    \(g[t_] := f[Mod[t, 2  Pi, \(-Pi\)]]\), "\[IndentingNewLine]", 
    \(w[n_, N_] := 
      Table[\((E^\((2*Pi*I/N)\))\)^\((i*n)\), {i, 0, 
          N - 1}]\), "\[IndentingNewLine]", 
    \(\(c[n_] := \((1/\((2*Pi)\))\)*
          NIntegrate[
            f[t]*E^\((\(-\ I\)\ n\ t)\), {t, \(-Pi\), 
              Pi}];\)\), "\[IndentingNewLine]", 
    \(\(y[q_] := 
        Table[g[t], {t, 0.0, 2  Pi - 2  N[Pi]/q, 
            2  N[Pi]/q}];\)\), "\[IndentingNewLine]", 
    \(\(Y[n_, 
          N_] := \((1/
              N)\)*\((y[N] . \[Omega][n, 
                N])\);\)\[IndentingNewLine]\), "\[IndentingNewLine]", 
    \(comparacoef[p_]\  := \ 
      Prepend[Chop[
            Table[{n, c[n], N[Y[n, X]]}, {n, 0, 
                14}]], {"\<n\>", "\<c[n]\>", "\<Y[n,\>" <> 
              ToString[TraditionalForm[p]] <> "\<]\>"}] // 
        TableForm\[IndentingNewLine]\), "\[IndentingNewLine]", 
    \(\(Print["\<Tabla para N=100\>"];\)\), "\[IndentingNewLine]", 
    \(comparacoef[100]\[IndentingNewLine]\), "\[IndentingNewLine]", 
    \(\(Print["\<Tabla para N=400\>"];\)\), "\[IndentingNewLine]", 
    \(comparacoef[400]\)}], "Input"],

Cell[BoxData[
    \(comparacoeff[30]\)], "Input"],

Cell["\<\
Naturalmente, la aproximaci\[OAcute]n es mejor cuantos m\[AAcute]s puntos \
tenga la muestra.\
\>", "Text"],

Cell[BoxData[
    \(comparacoeff[100]\)], "Input"],

Cell["\<\
Para evitar interpretaciones incorrectas, es frecuente representar solamente \
la primera mitad de la transformadad de Fourier discreta. Por supuesto, lo \
usual es representar el espectro de amplitudes pues, en general, la \
transformadad de Fourier discreta tiene valores complejos. El siguiente \
comando representa el espectro de amplitudes de la DFT centrado en cero.\
\>", "Text"],

Cell[BoxData[
    \(centerplotamplitudesDFT[func_, razonmuestreo_, tiempo_, opts___] := 
      Module[{puntos, muestra, nummuestras, transformada}, 
        nummuestras = 
          Floor[tiempo*razonmuestreo]; \[IndentingNewLine]muestra = 
          Map[func, \((Range[nummuestras] - 1)\)/razonmuestreo] // 
            N; \ \[IndentingNewLine]transformada = 
          Abs[DFT[muestra]]; \[IndentingNewLine]puntos = 
          Transpose[{\((Range[\(-nummuestras\)/2 + 1, nummuestras/2])\)/
                razonmuestreo, 
              RotateRight[transformada, 
                nummuestras/2 - 1]}]; \[IndentingNewLine]ListPlot[puntos, 
          PlotStyle -> {PointSize\ [0.016], Hue[0]}, 
          Epilog \[Rule] 
            Map[Line, puntos /. {x_, y_} \[Rule] {{x, 0}, {x, y}}], 
          Axes \[Rule] True, 
          AxesLabel -> {"\<\[Nu]\>", \*"\"\<|\!\(Y\_n\)|\>\""}, 
          Ticks \[Rule] {Drop[
                Union[Table[
                    If[transformada[\([k]\)] > 0, {k/razonmuestreo, 
                        k}, {}], {k, \(-nummuestras\)/2, nummuestras/2}]], 
                1], Automatic}, PlotRange -> All, opts];]\)], "Input"],

Cell[BoxData[
    \(centerplotamplitudesDFT[P, 32/5, 5]\)], "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "DFT en ",
  StyleBox["Mathematica",
    FontSlant->"Italic"]
}], "Section"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " tiene un comando \"Fourier[lista]\" para calcular la DFT que usa el \
algoritmo de la Transformada R\[AAcute]pida de Fourier. Pero ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " define la DFT en la forma siguiente:\n\t\t\t\t",
  Cell[BoxData[
      \(TraditionalForm\`Y\_n = \(1\/\@N\) \(\[Sum]\+\(k = 1\)\%N\(\( 
                  y\_k\) \(\[ExponentialE]\^\(2\ \[ImaginaryI]\ \[Pi]\ \((n - 
                        1)\) \((\ k - 1)\)/
                      N\)\)\(\ \ \ \ \ \ \ \ \ \ \ \ \)\((n = 1, 2,  ... , 
                N)\)\(\ \)\)\)\)]],
  "\nes decir, divide por ",
  Cell[BoxData[
      \(TraditionalForm\`\@N\)]],
  "en vez de por ",
  StyleBox["N",
    FontSlant->"Italic"],
  " y conjuga las exponenciales. Para que el comando \"Fourier[lista]\" \
proporcione la DFT que hemos definido nosotros hay que ajustar unos par\
\[AAcute]metros (consulta la ayuda de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "). Ejecuta las siguientes celdas para entender la relaci\[OAcute]n entre \
nuestro comando DFT[ ] y Fourier[ ]."
}], "Text"],

Cell[BoxData[
    \(DFT[{1.  + 1.  I, 2. , 3. , 4. , 5. }]\)], "Input"],

Cell[BoxData[
    \(1/Sqrt[5. ] 
      RotateLeft[
        Reverse[Fourier[{1.  + I, 2. , 3. , 4. , 5. }]], \(-1\)]\)], "Input"],

Cell[BoxData[
    \(\(\(Fourier[{1.  + 1.  I, 2. , 3. , 4. , 5. }, 
      FourierParameters \[Rule] {\(-1\), \(-1\)}]\)\( (*\ 
      no\ funciona\ en\ la\ versi\[OAcute]n\ 3.0\ *) \)\)\)], "Input"],

Cell["\<\
No te debe caber duda de cu\[AAcute]l es el que hay que usar para hacer c\
\[AAcute]lculos.\
\>", "Text"],

Cell[BoxData[{
    \(Clear[lista]\), "\[IndentingNewLine]", 
    \(\(lista = Table[Random[], {1024}];\)\), "\[IndentingNewLine]", 
    \(\(Timing[
        Fourier[lista, 
          FourierParameters \[Rule] {\(-1\), \(-1\)}]]\)[\([1]\)]\  (*\ 
      visto\ y\ no\ visto\ *) \), "\[IndentingNewLine]", 
    \(\(Timing[DFT[lista]]\)[\([1]\)] (*\ espera\ un\ poco, \ 
      ten\ paciencia; \ 
      hay\ que\ hacer\ m\[AAcute]s\ de\ un\ mill\[OAcute]n\ de\ operaciones\ *) \
\)}], "Input"],

Cell[TextData[{
  "Ahora puedes apreciar el ahorro que proporciona el algoritmo de la \
transformada r\[AAcute]pida de Fourier. Pongamos a prueba el algoritmo con \
una muestra grande de ",
  Cell[BoxData[
      \(TraditionalForm\`2\^15 = 32678\)]],
  " datos. Solamente pretender almacenar la matriz de los \[Omega][n,N] para \
N=32678 ya ser\[IAcute]a un problema. "
}], "Text"],

Cell[BoxData[{
    \(Clear[lista]\), "\[IndentingNewLine]", 
    \(\(lista = Table[Random[], {32678}];\)\), "\[IndentingNewLine]", 
    \(\(Timing[
        Fourier[lista, 
          FourierParameters \[Rule] {\(-1\), \(-1\)}]]\)[\([1]\)]\), "\
\[IndentingNewLine]", 
    \(Clear[lista]\)}], "Input"],

Cell["No est\[AAcute] mal \[DownQuestion]verdad?.", "Text"],

Cell[CellGroupData[{

Cell["Ejercicio 3", "Exercise"],

Cell[TextData[{
  "a) Define un comando \"CirculantMatrix[lista]\" que construye una matriz \
circulante a partir de una lista dada. Usa para ello los comandos Transpose[ \
], RotateRight[ ], NestList[ ].\nb) Define un comando CiclicConvolve[x,y] que \
calcule la convoluci\[OAcute]n c\[IAcute]clica ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["x",
            FontWeight->"Bold"], 
          StyleBox[
            FormBox["\[CircleDot]",
              "TraditionalForm"],
            FontWeight->"Bold"], 
          StyleBox[" ",
            FontWeight->"Bold"], 
          StyleBox["y",
            FontWeight->"Bold"]}], TraditionalForm]]],
  ".\nc) Comprueba simb\[OAcute]licamente para listas de 4 elementos que",
  Cell[BoxData[
      FormBox[
        StyleBox[
          RowBox[{" ", 
            RowBox[{
              FormBox[
                StyleBox[
                  RowBox[{"x", 
                    FormBox["\[CircleDot]",
                      "TraditionalForm"], " ", "y"}],
                  FontWeight->"Bold"],
                "TraditionalForm"], "=", \(y\[CircleDot]x\)}]}],
          FontWeight->"Bold"], TraditionalForm]]],
  ".\nd) Comprueba simb\[OAcute]licamente para listas de N=4 elementos que ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(DFT[x\[CircleDot]\ y] = N\ DFT[x]\ DFT[y]\),
          FontWeight->"Bold"], TraditionalForm]]],
  "."
}], "ExerciseText"],

Cell[BoxData[
    \(Transpose[NestList[RotateRight, {a, b, c, d}, 3]] // 
      MatrixForm\)], "Input"],

Cell[BoxData[
    \(CirculantMatrix[lista_] := 
      Transpose[NestList[RotateRight, lista, Length[lista] - 1]]\)], "Input"],

Cell[BoxData[
    \(CirculantMatrix[{a, b, c, d, e}] // MatrixForm\)], "Input"],

Cell[BoxData[
    \(CiclicConvolve[x_, y_] := CirculantMatrix[y] . x\)], "Input"],

Cell["Podemos comprobar la propiedad conmutativa de la convoluci\[OAcute]n", \
"Text"],

Cell[BoxData[{
    \(CiclicConvolve[{a, b, c, d}, {x, y, z, u}]\), "\[IndentingNewLine]", 
    \(CiclicConvolve[{x, y, z, u}, {a, b, c, d}]\)}], "Input"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " dispone de un comando \"ListConvolve[n\[UAcute]cleo,lista]\" (consulta la \
ayuda de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ") que con un ajuste de par\[AAcute]metros permite calcular convoluciones c\
\[IAcute]clicas (aunque el comando de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " es mucho m\[AAcute]s general)."
}], "Text"],

Cell[BoxData[
    \(ListConvolve[{a, b, c}, {x, y, z}, 1]\)], "Input"],

Cell[TextData[{
  "Podemos tambi\[EAcute]n comprobar la igualdad ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{"\[ScriptCapitalF]", " ", 
            RowBox[{"(", 
              RowBox[{
                StyleBox["x",
                  FontWeight->"Bold"], 
                FormBox[\(\(\ \)\(\[CircleDot]\)\),
                  "TraditionalForm"], " ", 
                StyleBox["y",
                  FontWeight->"Bold"]}], 
              StyleBox[")",
                FontWeight->"Bold"]}]}], 
          StyleBox["=",
            FontWeight->"Bold"], 
          RowBox[{
            RowBox[{
              StyleBox[
                RowBox[{
                  StyleBox["N",
                    FontWeight->"Bold"], "\[ScriptCapitalF]"}]], "(", 
              StyleBox["x",
                FontWeight->"Bold"], ")"}], 
            RowBox[{"\[ScriptCapitalF]", "(", 
              StyleBox["y",
                FontWeight->"Bold"], ")"}]}]}], TraditionalForm]]],
  "."
}], "Text"],

Cell[BoxData[{
    \(DFT[CiclicConvolve[{a, b, c}, {x, y, z}]] // 
      Expand\), "\[IndentingNewLine]", 
    \(3  DFT[{a, b, c}] DFT[{x, y, z}] // Expand\)}], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 4", "Exercise"],

Cell[TextData[{
  "a) Define, usando el comando DFT[ ], un comando \
\"interpol[muestra][t,period]\" que calcule el polinomio \
trigonom\[EAcute]trico con periodo igual a \"period\" que interpola una \
\"muestra\" dada de valores. Comprueba que tu comando funciona correctamente \
con algunos ejemplos sencillos.\nb) Considera el polinomio ",
  Cell[BoxData[
      \(TraditionalForm\`f(t) = 
        0.8\ \(cos(400*2\ \[Pi]\ t)\) + 0.6\ \(sen(1600*2\ \[Pi]\ t)\) + 
          0.4\ \(cos(2400*2  \[Pi]\ t)\) + 0.2\ \(sen(3600*2  \[Pi]t)\)\)]],
  ".\nMuestrea ",
  Cell[BoxData[
      \(TraditionalForm\`f(t)\)]],
  " con una frecuencia apropiada, m\[UAcute]ltiplo de la frecuencia \
fundamental, durante un periodo y llama \"samples\" a los valores obtenidos.\n\
c) Recupera ",
  Cell[BoxData[
      \(TraditionalForm\`f(t)\)]],
  " a partir de \"samples\" usando el comando que has definido en el apartado \
a).\nd) Calcula, usando el comando \"inversaDFT[ ]\" definido en el ejercicio \
1, una lista, que llamar\[AAcute]s \"Ker\", de manera que la lista DFT[Ker\
\[CircleDot]samples] tenga los mismos elementos que DFT[samples] excepto los \
que corresponden a las frecuencias 2400 y 3600 que deben ser cero.\nd) \
Calcula el polinomio trigonom\[EAcute]trico que interpola los valores Ker\
\[CircleDot]samples con periodo 1/400 y comprueba que coincide con ",
  Cell[BoxData[
      \(TraditionalForm\`f(t)\)]],
  " en el que se han suprimido los t\[EAcute]rminos correspondientes a las \
frecuencias 2400 y 3600."
}], "ExerciseText"],

Cell[BoxData[{
    \(Clear[f, samples]\), "\[IndentingNewLine]", 
    \(\(f[t_] = 
        0.3\ Cos[400\ 2  Pi\ t] + 0.6\ Sin[1200\ 2\ Pi\ t] + 
          0.3\ Cos[1600\ 2\ Pi\ t] + 0.3\ Cos[3600\ 2\ Pi\ t] - 
          0.5  Sin[2400\ 2  \[Pi]\ t];\)\), "\[IndentingNewLine]", 
    \(samples = muestra[f, 8000, 1/400]\), "\[IndentingNewLine]", 
    \(\(interpol[samples]\)[t, 1/400]\), "\[IndentingNewLine]", 
    \(DFT[samples]\)}], "Input"],

Cell[BoxData[{
    \(\(H = {1, 1, 1, 1, 1, 1, 0, 1, 1, 0, 1, 0, 1, 1, 0, 1, 1, 1, 1, 
          1};\)\), "\[IndentingNewLine]", 
    \(Ker = invDFT[H]\)}], "Input"],

Cell[BoxData[
    \(DFT[CiclicConvolve[Ker, samples]]/20\)], "Input"],

Cell[BoxData[
    \(conv = CiclicConvolve[Ker, samples]/20 // Chop\)], "Input"],

Cell[BoxData[
    \(\(interpol[conv]\)[t, 1/400]\)], "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Filtros", "Section"],

Cell[BoxData[{
    \(Off[General::spell1]\), "\[IndentingNewLine]", 
    \(Off[General::spell]\)}], "Input"],

Cell[BoxData[
    \(\(sizes = 
        Sort[Flatten[
            Table[2^i\ 3^j\ \ 5^k, {i, 1, 15}, {j, 0, 
                Floor[Log[3, 32768. /\((2^i)\)]]}, {k, 0, 
                Floor[Log[5, 32768. /\((2^i\ 3^j)\)]]}]]];\)\)], "Input"],

Cell[BoxData[
    \(eligesize[x_] := 
      Module[{p = Max[sizes], q}, \[IndentingNewLine]If[x \[LessEqual] \ p, 
          First[Select[sizes, \((# \[GreaterEqual] x)\) &]], 
          q = Ceiling[Log[2, N[x]/p]]; 
          2^q\ First[
              Select[sizes, \((# \[GreaterEqual] \((2^\(-q\))\)\ x)\) \
&]]]]\)], "Input"],

Cell[BoxData[
    \(filtropasobanda[sound_SampledSoundList, fmin_, fmax_] := 
      Block[{samps, srate, origsize, \ newsize, kern, nfmin, nfmax, 
          n}, \[IndentingNewLine]samps = 
          sound[\([1]\)]; \[IndentingNewLine]srate = 
          sound[\([2]\)]; \[IndentingNewLine]origsize = 
          Length[samps]; \[IndentingNewLine]newsize = 
          2*eligesize[origsize]; \[IndentingNewLine]samps = 
          Join[samps, 
            Table[0.0, {newsize - 
                  origsize}]]; \[IndentingNewLine]nfmin = \((fmin*newsize)\)/
            srate; \[IndentingNewLine]nfmax = \((fmax*newsize)\)/
            srate; \[IndentingNewLine]kern = 
          Table[If[n \[GreaterEqual] \ nfmin && \ n \[LessEqual] \ nfmax, 
              1.0, 0.0], {n, \((newsize/2)\) + 1}]; \[IndentingNewLine]kern = 
          Join[kern, 
            Take[Reverse[
                Drop[Drop[kern, 1], \(-1\)]]]]; \[IndentingNewLine]samps = 
          Take[Chop[
              Re[\[IndentingNewLine]InverseFourier[kern*Fourier[samps]]]], 
            origsize]; \[IndentingNewLine]samps = 
          samps/Max[Abs[samps]]; \[IndentingNewLine]Return[
          SampledSoundList[samps, srate]]\[IndentingNewLine]]\)], "Input"],

Cell[BoxData[{
    \(\(sines = 
        SampledSoundList[
          Table[N[0.3\ \((Sin[2\ Pi\ 400. \ x] + Sin[2\ Pi\ 1600. \ x] + 
                    Sin[2\ Pi\ 3600. \ x])\)], {x, 0, 1 - 1/22500.0, 
              1/22500.0}], 22500];\)\), "\n", 
    \(\(Show[Sound[sines]];\)\)}], "Input"],

Cell[BoxData[{
    \(\(lsine = filtropasobanda[sines, 0, 600];\)\), "\n", 
    \(\(Show[Sound[lsine]];\)\)}], "Input"],

Cell[BoxData[{
    \(\(msine = filtropasobanda[sines, 1500, 1700];\)\), "\n", 
    \(\(Show[Sound[msine]];\)\)}], "Input"],

Cell[BoxData[{
    \(\(hsine = filtropasobanda[sines, 3500, 3700];\)\), "\n", 
    \(\(Show[Sound[hsine]];\)\)}], "Input"],

Cell[BoxData[
    \(\(CombinedSoundShow[{Sound[sines], Sound[lsine], Sound[msine], 
          Sound[hsine]}];\)\)], "Input"],

Cell[BoxData[
    \(SetDirectory["\<D:\Docencia \
Informatica\Javier\Ingenieria_Informatica\Curso2005_2006\Calculo_Avanzado\P\
racticas\ \>"]\)], "Input"],

Cell[BoxData[{
    \(\(nessun = Import["\<pavrti.wav\>"];\)\), "\n", 
    \(Short[InputForm[nessun]]\)}], "Input"],

Cell[BoxData[
    \(\(Show[nessun];\)\)], "Input"],

Cell[BoxData[{
    \(\(nesunbajo = filtropasobanda[nessun[\([1]\)], 0, 1000];\)\), "\n", 
    \(\(Show[Sound[nesunbajo]];\)\)}], "Input"],

Cell[BoxData[{
    \(\(nesunmedio = 
        filtropasobanda[nessun[\([\)\(1\)\(]\)], 1000, 2000];\)\), "\n", 
    \(Show[Sound[nesunmedio]]\)}], "Input"],

Cell[BoxData[{
    \(\(nesunalto = filtropasobanda[nessun[\([1]\)], 2000, 8000];\)\), "\n", 
    \(\(Show[Sound[nesunalto]];\)\)}], "Input"],

Cell[BoxData[
    \(\(CombinedSoundShow[{nessun, Sound[nesunbajo], Sound[nesunmedio], 
          Sound[nesunalto]}];\)\)], "Input"],

Cell[BoxData[{
    \(\(papa = Import["\<papa.wav\>"];\)\), "\n", 
    \(\(Show[papa];\)\)}], "Input"],

Cell[BoxData[{
    \(\(filtropasobanda[papa[\([1]\)], 2000, 4000];\)\), "\n", 
    \(Show[Sound[%]]\)}], "Input"],

Cell[BoxData[{
    \(\(niniomedio = 
        filtropasobanda[papa[\([\)\(1\)\(]\)], 1000, 2000];\)\), "\n", 
    \(\(Show[Sound[niniomedio]];\)\)}], "Input"],

Cell[BoxData[{
    \(\(niniobajo = filtropasobanda[papa[\([1]\)], 0, 1000];\)\), "\n", 
    \(\(Show[Sound[niniobajo]];\)\)}], "Input"],

Cell[BoxData[
    \(convolucion[x_, y_] := 
      Module[{lx = Length[x], ly = Length[y]}, \[IndentingNewLine]Drop[
          Table[Sum[
              x[\([k]\)]*\ y[\([n - k]\)], {k, Max[1, n - ly], 
                Min[n - 1, lx]}], {n, 1, lx + ly}], 1]]\)], "Input"]
}, Open  ]]
},
FrontEndVersion->"5.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 685}},
WindowSize->{1016, 651},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Magnification->1.5,
StyleDefinitions -> "Classroom.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 49, 0, 99, "Title"],

Cell[CellGroupData[{
Cell[1828, 55, 78, 0, 93, "Section"],

Cell[CellGroupData[{
Cell[1931, 59, 31, 0, 68, "Exercise"],
Cell[1965, 61, 3125, 70, 675, "ExerciseText"],
Cell[5093, 133, 420, 10, 98, "Input"],
Cell[5516, 145, 233, 5, 124, "Input"],
Cell[5752, 152, 243, 8, 41, "Text"],
Cell[5998, 162, 153, 3, 72, "Input"],
Cell[6154, 167, 267, 5, 104, "Input"],
Cell[6424, 174, 120, 3, 41, "Text"],
Cell[6547, 179, 71, 1, 72, "Input"],
Cell[6621, 182, 43, 1, 72, "Input"],
Cell[6667, 185, 47, 1, 72, "Input"],
Cell[6717, 188, 123, 2, 72, "Input"],
Cell[6843, 192, 188, 3, 98, "Input"],
Cell[7034, 197, 159, 2, 98, "Input"],
Cell[7196, 201, 369, 6, 202, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7602, 212, 31, 0, 68, "Exercise"],
Cell[7636, 214, 1379, 39, 183, "Text"],
Cell[9018, 255, 272, 4, 124, "Input"],
Cell[9293, 261, 71, 1, 72, "Input"],
Cell[9367, 264, 1199, 24, 443, "Input"],
Cell[10569, 290, 1269, 27, 488, "Input"],
Cell[11841, 319, 49, 1, 72, "Input"],
Cell[11893, 322, 117, 3, 41, "Text"],
Cell[12013, 327, 50, 1, 72, "Input"],
Cell[12066, 330, 396, 6, 93, "Text"],
Cell[12465, 338, 1159, 21, 436, "Input"],
Cell[13627, 361, 68, 1, 72, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[13744, 368, 94, 4, 93, "Section"],
Cell[13841, 374, 1141, 27, 201, "Text"],
Cell[14985, 403, 71, 1, 72, "Input"],
Cell[15059, 406, 128, 3, 72, "Input"],
Cell[15190, 411, 197, 3, 98, "Input"],
Cell[15390, 416, 115, 3, 41, "Text"],
Cell[15508, 421, 486, 10, 202, "Input"],
Cell[15997, 433, 380, 8, 93, "Text"],
Cell[16380, 443, 299, 7, 150, "Input"],
Cell[16682, 452, 59, 0, 41, "Text"],

Cell[CellGroupData[{
Cell[16766, 456, 31, 0, 68, "Exercise"],
Cell[16800, 458, 1422, 38, 169, "ExerciseText"],
Cell[18225, 498, 103, 2, 72, "Input"],
Cell[18331, 502, 125, 2, 98, "Input"],
Cell[18459, 506, 79, 1, 72, "Input"],
Cell[18541, 509, 81, 1, 72, "Input"],
Cell[18625, 512, 86, 1, 41, "Text"],
Cell[18714, 515, 153, 2, 98, "Input"],
Cell[18870, 519, 431, 12, 67, "Text"],
Cell[19304, 533, 70, 1, 72, "Input"],
Cell[19377, 536, 1001, 30, 41, "Text"],
Cell[20381, 568, 169, 3, 98, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[20587, 576, 31, 0, 68, "Exercise"],
Cell[20621, 578, 1534, 29, 367, "ExerciseText"],
Cell[22158, 609, 442, 8, 202, "Input"],
Cell[22603, 619, 164, 3, 98, "Input"],
Cell[22770, 624, 69, 1, 72, "Input"],
Cell[22842, 627, 79, 1, 72, "Input"],
Cell[22924, 630, 61, 1, 72, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[23034, 637, 26, 0, 93, "Section"],
Cell[23063, 639, 108, 2, 98, "Input"],
Cell[23174, 643, 240, 5, 150, "Input"],
Cell[23417, 650, 329, 7, 124, "Input"],
Cell[23749, 659, 1224, 22, 462, "Input"],
Cell[24976, 683, 292, 6, 150, "Input"],
Cell[25271, 691, 118, 2, 98, "Input"],
Cell[25392, 695, 122, 2, 98, "Input"],
Cell[25517, 699, 122, 2, 98, "Input"],
Cell[25642, 703, 124, 2, 72, "Input"],
Cell[25769, 707, 154, 3, 124, "Input"],
Cell[25926, 712, 114, 2, 98, "Input"],
Cell[26043, 716, 50, 1, 72, "Input"],
Cell[26096, 719, 137, 2, 98, "Input"],
Cell[26236, 723, 154, 3, 98, "Input"],
Cell[26393, 728, 140, 2, 98, "Input"],
Cell[26536, 732, 131, 2, 98, "Input"],
Cell[26670, 736, 101, 2, 98, "Input"],
Cell[26774, 740, 113, 2, 98, "Input"],
Cell[26890, 744, 157, 3, 98, "Input"],
Cell[27050, 749, 135, 2, 98, "Input"],
Cell[27188, 753, 269, 5, 124, "Input"]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

